/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/*
 * Linux-specific trace definitions
 *
 * $Id: Trace-plat.h,v 1.11 2001/09/22 20:10:32 dcraft Exp $
 *
 * $Log: Trace-plat.h,v $
 * Revision 1.11  2001/09/22 20:10:32  dcraft
 * Remove kiobufs from cxiKernelIODescriptor_t.  Use temporary
 * kiobufs for map/unmap.   Remove dead code and dead comments
 * in portability layer and update readmes and license.
 * Fix traceback to appear in mmfs.log file.
 *
 * Revision 1.10  2001/07/19 23:25:29  dcraft
 * Modified linux trace to allow non blocking trace record
 * writes (format is TRACE?N).  New gpfs swapd process created
 * which is responsible for reclaiming inodes (5 percent every
 * time it runs).  Marked all our inodes so that they would be
 * ignored by linux kswapd.  Added "unused" inode to inode
 * cache that could be used as a signal that linux kswapd is
 * running and kick off gpfs swapd.  Added means to ignore attempts
 * to kill mmfsd by kswapd if the system gets low on memory.
 * All done in an attempt to avoid kswapd premature wakeup on simple
 * locks and mutexes.
 *
 * Revision 1.9  2001/04/13 21:00:42  jpalmer
 * Add trace class slot for NSS
 *
 * Revision 1.8  2001/03/29 21:29:23  dixonbp
 * Preparations for converting files to .c
 *
 * Revision 1.7  2001/01/15 18:07:46  kywang
 * Add disk lease traces.
 *
 * Revision 1.6  2000/12/15 13:57:17  gjertsen
 * Clean up documentation.
 *
 * Revision 1.5  2000/11/22 22:28:04  wyllie
 * Use BEGIN_FAR_CODE/END_FAR_CODE macros to generate code that is rarely
 * executed far away from the common code, to improve Icache behavior on
 * i386.  Modify FAR_TRACE asm code for clarity.
 *
 * Revision 1.4  2000/11/03 19:27:41  wyllie
 * Improve cache performance of tracing on i386 under FAR_TRACE ifdef.  Also
 * make trace flags be chars instead of ints to use less D-cache space.
 *
 * Revision 1.3  2000/11/02 19:46:57  gjertsen
 * Linux code split.
 *
 *
 */

#ifndef _h_Trace_plat
#define _h_Trace_plat

#ifdef GPFS_PRINTF
#  ifdef __KERNEL__
#    ifdef __cplusplus
       extern "C"
       {
         int printk(const char * fmt, ...)
                    __attribute__ ((format (printf, 1, 2)));
       }
#    else  /* !__cplusplus */
       extern int printk(const char * fmt, ...)
                         __attribute__ ((format (printf, 1, 2)));
#    endif  /* __cplusplus */
#  endif  /* __KERNEL__ */
#endif  /* GPFS_PRINTF */


/* Maximum number of trace classes */
#define MAX_TRACE_CLASSES 50


#ifdef _KERNEL
#  define GPFS_NOTICE "<5>"
#endif

/* Define a global test for whether or not tracing is on.  On Linux, there
   is no way to efficiently test this, so assume tracing is always on. */
# define _GBL_TRC_IS_ON 1


/* In the daemon, trace macros always reference the trace flags through
   the pointer TraceFlagsP.  There is a copy of this pointer in the GPFS
   daemon, that initially points to PrivateTraceFlagsArray.  After the
   shared segment has been initialized, the contents of this array are
   copied into Shared.traceFlags and TraceFlagsP is changed to point to
   this shared copy.  In the kernel, TraceFlagsP is an array of trace
   levels.  This is kept in sync with Shared.traceFlags by the
   kxSetTraceLevel kernel call whenever 'mmfsadm trace foo n' changes
   any trace flags.  */
#ifdef DEFINE_TRACE_GBL_VARS
# ifdef _KERNEL
    char TraceFlagsP[MAX_TRACE_CLASSES] = { 0 };
# else
    char PrivateTraceFlagsArray[MAX_TRACE_CLASSES] = { 0 };
    char* TraceFlagsP = PrivateTraceFlagsArray;
# endif
#else
# ifdef _KERNEL
    extern char TraceFlagsP[MAX_TRACE_CLASSES];
# else
    extern char PrivateTraceFlagsArray[MAX_TRACE_CLASSES];
    extern char* TraceFlagsP;
# endif
#endif  /* DEFINE_TRACE_GBL_VARS */


/* Define macros for code that is generated before and after the actual
   trace call.  If FAR_TRACE is #defined, the actual call to the trace
   subroutine will be placed far away from the test of whether or not
   tracing is turned on.  When tracing is turned off, this technique
   reduces the number of I-cache misses, thereby improving performance
   significantly (5-10%).  Use of the FAR_TRACE option is not compatible
   with -g, and requires compiler options -fno-exceptions and
   -fno-defer-pop to insure that correct code is generated. */
#ifdef FAR_TRACE
# ifdef GPFS_ARCH_I386
#   define _TR_BEFORE __asm__(                                \
                        " jmp 2f\n"                           \
                        ".section .text.trace,\"ax\"\n"       \
                        "2:\n"                                \
                      );
#   define _TR_AFTER  __asm__(                                \
                        " jmp 1f\n"                           \
                        ".previous\n"                         \
                        "1:\n"                                \
                      );
# else
#   define _TR_BEFORE
#   define _TR_AFTER
# endif  /* GPFS_ARCH_I386 */
#else
# define _TR_BEFORE
# define _TR_AFTER
#endif  /* FAR_TRACE */


#ifdef _KERNEL
# define PDEBUG(_c, _l, _fmt, args...) \
    if (_TRACE_IS_ON(_c, _l)) printk( GPFS_NOTICE "kp %X:" _fmt, cxiGetThreadId() ,## args); else NOOP
#else
#     ifdef __cplusplus
  extern "C" int ktrace(const char *fmt, ...);
#     else  /* !__cplusplus */
  extern  int ktrace(const char *fmt, ...);
#     endif
# define PDEBUG(_c, _l, _fmt, args...) \
    if (_TRACE_IS_ON(_c, _l)) ktrace(_fmt, args); else NOOP
#endif  /* _KERNEL */


/* Special values for pos field in _STrace calls */
#define _TR_FORMAT_I 250   /* all integer arguments */
#define _TR_FORMAT_F 251   /* all integer arguments, plus the last argument
                              is a float */
#define _TR_FORMAT_X 252   /* preformatted string from TRACEnX */


#ifndef GPFS_PRINTF

/* NOTE: following _TRACExxx macros are used by the tracing facility but
   should NOT be explicitly used in the gpfs source code. These are
   intended to keep trcid.h from getting too large. */

/* Define the trace hook macros used by the generated code in trcid.h for
   all-integer calls */
#define _TRACE0D(hw)           _STrace(hw, 0, _TR_FORMAT_I, 1)
#define _TRACE1D(hw, args...)  _STrace(hw, 1, _TR_FORMAT_I,##args)
#define _TRACE2D(hw, args...)  _STrace(hw, 2, _TR_FORMAT_I,##args)
#define _TRACE3D(hw, args...)  _STrace(hw, 3, _TR_FORMAT_I,##args)
#define _TRACE4D(hw, args...)  _STrace(hw, 4, _TR_FORMAT_I,##args)
#define _TRACE5D(hw, args...)  _STrace(hw, 5, _TR_FORMAT_I,##args)
#define _TRACE6D(hw, args...)  _STrace(hw, 6, _TR_FORMAT_I,##args)
#define _TRACE7D(hw, args...)  _STrace(hw, 7, _TR_FORMAT_I,##args)
#define _TRACE8D(hw, args...)  _STrace(hw, 8, _TR_FORMAT_I,##args)
#define _TRACE9D(hw, args...)  _STrace(hw, 9, _TR_FORMAT_I,##args)
#define _TRACE10D(hw, args...) _STrace(hw, 10, _TR_FORMAT_I,##args)
#define _TRACE11D(hw, args...) _STrace(hw, 11, _TR_FORMAT_I,##args)
#define _TRACE12D(hw, args...) _STrace(hw, 12, _TR_FORMAT_I,##args)

#ifdef LTRACE_FUTURE
#define _TRACE13D(hw, args...) _STrace(hw, 13, _TR_FORMAT_I,##args)
#define _TRACE14D(hw, args...) _STrace(hw, 14, _TR_FORMAT_I,##args)
#define _TRACE15D(hw, args...) _STrace(hw, 15, _TR_FORMAT_I,##args)
#define _TRACE16D(hw, args...) _STrace(hw, 16, _TR_FORMAT_I,##args)
#define _TRACE17D(hw, args...) _STrace(hw, 17, _TR_FORMAT_I,##args)
#define _TRACE18D(hw, args...) _STrace(hw, 18, _TR_FORMAT_I,##args)
#define _TRACE19D(hw, args...) _STrace(hw, 19, _TR_FORMAT_I,##args)
#define _TRACE20D(hw, args...) _STrace(hw, 20, _TR_FORMAT_I,##args)

#define TRCGENT(0, hookid, trcid, len, trcTemp) (void)0
#endif  /* LTRACE_FUTURE */

/* non blocking versions */
#define _TRACE0D_NB(hw)           _STraceNB(hw, 0, _TR_FORMAT_I, 1)
#define _TRACE1D_NB(hw, args...)  _STraceNB(hw, 1, _TR_FORMAT_I,##args)
#define _TRACE2D_NB(hw, args...)  _STraceNB(hw, 2, _TR_FORMAT_I,##args)
#define _TRACE3D_NB(hw, args...)  _STraceNB(hw, 3, _TR_FORMAT_I,##args)
#define _TRACE4D_NB(hw, args...)  _STraceNB(hw, 4, _TR_FORMAT_I,##args)
#define _TRACE5D_NB(hw, args...)  _STraceNB(hw, 5, _TR_FORMAT_I,##args)
#define _TRACE6D_NB(hw, args...)  _STraceNB(hw, 6, _TR_FORMAT_I,##args)
#define _TRACE7D_NB(hw, args...)  _STraceNB(hw, 7, _TR_FORMAT_I,##args)
#define _TRACE8D_NB(hw, args...)  _STraceNB(hw, 8, _TR_FORMAT_I,##args)
#define _TRACE9D_NB(hw, args...)  _STraceNB(hw, 9, _TR_FORMAT_I,##args)
#define _TRACE10D_NB(hw, args...) _STraceNB(hw, 10, _TR_FORMAT_I,##args)
#define _TRACE11D_NB(hw, args...) _STraceNB(hw, 11, _TR_FORMAT_I,##args)
#define _TRACE12D_NB(hw, args...) _STraceNB(hw, 12, _TR_FORMAT_I,##args)

#ifdef LTRACE_FUTURE
#define _TRACE13D_NB(hw, args...) _STraceNB(hw, 13, _TR_FORMAT_I,##args)
#define _TRACE14D_NB(hw, args...) _STraceNB(hw, 14, _TR_FORMAT_I,##args)
#define _TRACE15D_NB(hw, args...) _STraceNB(hw, 15, _TR_FORMAT_I,##args)
#define _TRACE16D_NB(hw, args...) _STraceNB(hw, 16, _TR_FORMAT_I,##args)
#define _TRACE17D_NB(hw, args...) _STraceNB(hw, 17, _TR_FORMAT_I,##args)
#define _TRACE18D_NB(hw, args...) _STraceNB(hw, 18, _TR_FORMAT_I,##args)
#define _TRACE19D_NB(hw, args...) _STraceNB(hw, 19, _TR_FORMAT_I,##args)
#define _TRACE20D_NB(hw, args...) _STraceNB(hw, 20, _TR_FORMAT_I,##args)
#endif

#define _TRACE1F(hw, args...) _STrace(hw, 0, _TR_FORMAT_F,##args)
#define _TRACE2F(hw, args...) _STrace(hw, 1, _TR_FORMAT_F,##args)
#define _TRACE3F(hw, args...) _STrace(hw, 2, _TR_FORMAT_F,##args)
#define _TRACE4F(hw, args...) _STrace(hw, 3, _TR_FORMAT_F,##args)
#define _TRACE5F(hw, args...) _STrace(hw, 4, _TR_FORMAT_F,##args)
#define _TRACE6F(hw, args...) _STrace(hw, 5, _TR_FORMAT_F,##args)
#define _TRACE7F(hw, args...) _STrace(hw, 6, _TR_FORMAT_F,##args)
#define _TRACE8F(hw, args...) _STrace(hw, 7, _TR_FORMAT_F,##args)
#define _TRACE9F(hw, args...) _STrace(hw, 8, _TR_FORMAT_F,##args)

#define _TRACE1F_NB(hw, args...) _STraceNB(hw, 0, _TR_FORMAT_F,##args)
#define _TRACE2F_NB(hw, args...) _STraceNB(hw, 1, _TR_FORMAT_F,##args)
#define _TRACE3F_NB(hw, args...) _STraceNB(hw, 2, _TR_FORMAT_F,##args)
#define _TRACE4F_NB(hw, args...) _STraceNB(hw, 3, _TR_FORMAT_F,##args)
#define _TRACE5F_NB(hw, args...) _STraceNB(hw, 4, _TR_FORMAT_F,##args)
#define _TRACE6F_NB(hw, args...) _STraceNB(hw, 5, _TR_FORMAT_F,##args)
#define _TRACE7F_NB(hw, args...) _STraceNB(hw, 6, _TR_FORMAT_F,##args)
#define _TRACE8F_NB(hw, args...) _STraceNB(hw, 7, _TR_FORMAT_F,##args)
#define _TRACE9F_NB(hw, args...) _STraceNB(hw, 8, _TR_FORMAT_F,##args)

#endif /* GPFS_PRINTF */

#endif  /* _h_Trace_plat */
